<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The pricing scheme details.
 */
class SubscriptionPricingScheme implements \JsonSerializable
{
    /**
     * @var int|null
     */
    private $version;

    /**
     * @var Money|null
     */
    private $fixedPrice;

    /**
     * @var string|null
     */
    private $pricingModel;

    /**
     * @var PricingTier[]|null
     */
    private $tiers;

    /**
     * @var string|null
     */
    private $createTime;

    /**
     * @var string|null
     */
    private $updateTime;

    /**
     * Returns Version.
     * The version of the pricing scheme.
     */
    public function getVersion(): ?int
    {
        return $this->version;
    }

    /**
     * Sets Version.
     * The version of the pricing scheme.
     *
     * @maps version
     */
    public function setVersion(?int $version): void
    {
        $this->version = $version;
    }

    /**
     * Returns Fixed Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getFixedPrice(): ?Money
    {
        return $this->fixedPrice;
    }

    /**
     * Sets Fixed Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps fixed_price
     */
    public function setFixedPrice(?Money $fixedPrice): void
    {
        $this->fixedPrice = $fixedPrice;
    }

    /**
     * Returns Pricing Model.
     * The pricing model for tiered plan. The `tiers` parameter is required.
     */
    public function getPricingModel(): ?string
    {
        return $this->pricingModel;
    }

    /**
     * Sets Pricing Model.
     * The pricing model for tiered plan. The `tiers` parameter is required.
     *
     * @maps pricing_model
     */
    public function setPricingModel(?string $pricingModel): void
    {
        $this->pricingModel = $pricingModel;
    }

    /**
     * Returns Tiers.
     * An array of pricing tiers which are used for billing volume/tiered plans. pricing_model field has to
     * be specified.
     *
     * @return PricingTier[]|null
     */
    public function getTiers(): ?array
    {
        return $this->tiers;
    }

    /**
     * Sets Tiers.
     * An array of pricing tiers which are used for billing volume/tiered plans. pricing_model field has to
     * be specified.
     *
     * @maps tiers
     *
     * @param PricingTier[]|null $tiers
     */
    public function setTiers(?array $tiers): void
    {
        $this->tiers = $tiers;
    }

    /**
     * Returns Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getCreateTime(): ?string
    {
        return $this->createTime;
    }

    /**
     * Sets Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps create_time
     */
    public function setCreateTime(?string $createTime): void
    {
        $this->createTime = $createTime;
    }

    /**
     * Returns Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getUpdateTime(): ?string
    {
        return $this->updateTime;
    }

    /**
     * Sets Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps update_time
     */
    public function setUpdateTime(?string $updateTime): void
    {
        $this->updateTime = $updateTime;
    }

    /**
     * Converts the SubscriptionPricingScheme object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionPricingScheme object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionPricingScheme',
            [
                'version' => $this->version,
                'fixedPrice' => $this->fixedPrice,
                'pricingModel' => $this->pricingModel,
                'tiers' => $this->tiers,
                'createTime' => $this->createTime,
                'updateTime' => $this->updateTime
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->version)) {
            $json['version']       = $this->version;
        }
        if (isset($this->fixedPrice)) {
            $json['fixed_price']   = $this->fixedPrice;
        }
        if (isset($this->pricingModel)) {
            $json['pricing_model'] = $this->pricingModel;
        }
        if (isset($this->tiers)) {
            $json['tiers']         = $this->tiers;
        }
        if (isset($this->createTime)) {
            $json['create_time']   = $this->createTime;
        }
        if (isset($this->updateTime)) {
            $json['update_time']   = $this->updateTime;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
